/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketFilterInterface
extends CommInterface {
    private String address;
    private int port;
    private Socket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    private ByteBuffer bb = new ByteBuffer();

    public SocketFilterInterface(String address, int port) {
        this.port = port;
        this.address = address;
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.SocketFilter;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    private void printChar(int c) {
        System.out.print("{");
        if (c >= 32) {
            System.out.print((char)c);
        } else {
            System.out.print(StringUtil.hex2(c));
        }
        System.out.print("}");
    }

    private boolean openLocal() {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.address, this.port), 100);
            this.socket.setSoTimeout(20);
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public void flush() {
        try {
            this.bb.clear();
            while (this.isOpen() && this.is.available() > 0) {
                this.is.read();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public synchronized void open() {
        if (!this.openLocal()) {
            SerialInterface.sleep(50);
            this.openLocal();
        }
        this.log("Open");
    }

    @Override
    public synchronized void close() {
        try {
            if (this.socket != null) {
                SerialInterface.sleep(30);
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            this.socket = null;
        }
    }

    @Override
    public synchronized boolean write(String msg) {
        try {
            this.log("Tx: ", msg);
            this.os.write((String.valueOf(msg) + this.eol).getBytes());
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isData() {
        block3: {
            int c;
            block4: {
                try {
                    if (this.is.available() <= 0) break block3;
                    c = this.is.read();
                    if (c != 10 && c != 13) break block4;
                    return false;
                }
                catch (IOException iOException) {
                    this.close();
                    return false;
                }
            }
            this.bb.append((char)c);
            return true;
        }
        return false;
    }

    @Override
    public synchronized String read() {
        return this.read(this.timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        if (!this.isOpen()) {
            return null;
        }
        long finalTime = System.currentTimeMillis() + (long)timeout;
        try {
            while (finalTime > System.currentTimeMillis()) {
                if (this.is.available() > 0) {
                    int c = this.is.read();
                    if (c == this.eol.charAt(0)) {
                        String s = this.bb.toString();
                        this.log("Rx: ", s);
                        this.bb.clear();
                        while (this.is.available() > 0) {
                            this.is.read();
                        }
                        return s;
                    }
                    if (c == 13 || c == 10) continue;
                    this.bb.append((char)c);
                    continue;
                }
                SerialInterface.sleep(1);
            }
        }
        catch (IOException e) {
            this.close();
            System.out.println("  Socket read exception:");
            e.printStackTrace(System.out);
        }
        this.log("   Rx timeout " + timeout + "ms   In buffer: " + this.bb.toString());
        return null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isOutputShutdown() && !this.socket.isInputShutdown();
    }

    @Override
    public int getSerialId() {
        if (!this.isOpen()) {
            return -1;
        }
        byte[] adr = this.socket.getInetAddress().getAddress();
        long n = 0L;
        int i = 0;
        while (i < adr.length) {
            n = n * 256L + (long)adr[i];
            ++i;
        }
        return (int)(n % 100L);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.address;
    }
}

