/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SerialPacketInterface
extends SerialInterface
implements SerialPortDataListener,
CommDataInterface {
    private int packetLength = 0;
    private byte packetStart = 0;
    private byte[] packetStartList = null;
    private byte[] packetEndList = null;
    private int blockCount = 1;
    private int blockCounter = 0;
    private byte packetStartMask = 0;
    private CommDataInterface.PacketFormat packetFormat;
    private ByteBuffer receivedData = new ByteBuffer();
    private ArrayBlockingQueue<byte[]> queue = new ArrayBlockingQueue(100);
    private int answerTimeout = 0;
    private long timestamp = 0L;
    static Long refTime = null;

    public SerialPacketInterface(SerialPort p, boolean debugLog) {
        super(p);
        this.debugLog = debugLog;
    }

    @Override
    public void setAnswerTimeout(int timeout) {
        this.answerTimeout = timeout;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetEndList = null;
        this.packetStart = 0;
        this.packetStartMask = 0;
        this.packetLength = 0;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetEndList = null;
        this.packetStart = 0;
        this.packetStartMask = 0;
        this.packetLength = packetLength;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetEndList = null;
        this.packetStart = packetStart;
        this.packetStartMask = (byte)-1;
        this.packetLength = packetLength;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, byte packetStartMask, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetEndList = null;
        this.packetStart = packetStart;
        this.packetStartMask = packetStartMask;
        this.packetLength = packetLength;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = packetStart;
        this.packetEndList = null;
        this.packetStart = packetStart[0];
        this.packetStartMask = (byte)-1;
        this.packetLength = packetLength;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    @Override
    public synchronized void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, byte[] packetEnd, int count) {
        this.packetFormat = packetFormat;
        this.packetStartList = packetStart;
        this.packetEndList = packetEnd;
        this.packetStart = packetStart.length == 0 ? (byte)0 : packetStart[0];
        this.packetStartMask = (byte)-1;
        this.packetLength = 0;
        this.blockCount = count;
        this.receivedData.setLength(0);
        this.blockCounter = 0;
    }

    private synchronized boolean writeDataInternal(byte[] data) {
        if (!this.serialPort.isOpen()) {
            return false;
        }
        int n = 0;
        long time = System.currentTimeMillis();
        if (this.debugLog) {
            this.logLog("Tx: " + StringUtil.hexN(data));
        }
        while (n < data.length) {
            int i = this.serialPort.writeBytes(data, data.length - n, n);
            n += i;
            SerialInterface.sleep(1);
            if (i >= 0 && System.currentTimeMillis() - time <= (long)this.timeout) continue;
            return i == data.length;
        }
        return true;
    }

    private long currentTimeMillis() {
        if (refTime == null) {
            refTime = System.nanoTime();
        }
        return (System.nanoTime() - refTime) / 1000000L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean writeData(byte[] data) {
        if (this.answerTimeout <= 0) {
            return this.writeDataInternal(data);
        }
        n = 0;
        this.flush();
        t = 0L;
        while (n < 4) {
            if (this.writeDataInternal(data)) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                CommInterface.sleep(1);
lbl10:
                // 2 sources

                ** while (this.serialPort.bytesAwaitingWrite() > 0)
            }
lbl11:
            // 1 sources

            t = System.currentTimeMillis() + (long)this.answerTimeout;
            ++n;
            while (this.receivedData.getSize() == 0 && t > System.currentTimeMillis()) {
                CommInterface.sleep(1);
            }
            if (this.receivedData.getSize() <= 0) continue;
            return true;
        }
        if (this.debugLog) {
            this.logLog("*** Timeout ***");
        }
        return true;
    }

    @Override
    public byte[] readData() {
        return this.readData(this.timeout);
    }

    @Override
    public synchronized byte[] readData(int timeout) {
        try {
            while (this.queue.size() > 5) {
                this.queue.poll();
            }
            byte[] b = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            if (b != null) {
                if (this.debugLog) {
                    this.logLog("Rx: " + StringUtil.hexN(b));
                }
                return b;
            }
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    @Override
    public synchronized byte[] writeReadData(byte[] data) {
        this.writeData(data);
        return this.readData();
    }

    @Override
    public boolean write(String msg) {
        return false;
    }

    @Override
    public boolean isData() {
        return this.queue.size() > 0;
    }

    @Override
    public String read() {
        return null;
    }

    @Override
    public String read(int timeout) {
        return null;
    }

    @Override
    public synchronized void flush() {
        if (this.debugLog && this.receivedData.getSize() > 0) {
            this.logLog("Flush: " + StringUtil.hexN(this.receivedData.getAsArray()));
        }
        this.receivedData.setLength(0);
        this.queue.clear();
        this.blockCounter = 0;
    }

    @Override
    public int getListeningEvents() {
        return 17;
    }

    private boolean inList(byte b) {
        byte[] byArray = this.packetStartList;
        int n = this.packetStartList.length;
        int n2 = 0;
        while (n2 < n) {
            byte bb = byArray[n2];
            if (b == bb) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        try {
            byte[] b = event.getReceivedData();
            if (this.packetFormat == null) {
                return;
            }
            int i = 0;
            switch (this.packetFormat) {
                case FixedLength: {
                    while (i < b.length) {
                        this.receivedData.append(b[i]);
                        ++i;
                        if (this.receivedData.getSize() < this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                    }
                    break;
                }
                case FixedLengthTimeout: {
                    long t = System.currentTimeMillis();
                    if (t - this.timestamp > 10L) {
                        this.timestamp = t;
                        this.receivedData.clear();
                    }
                    while (i < b.length) {
                        this.receivedData.append(b[i]);
                        ++i;
                        if (this.receivedData.getSize() < this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                    }
                    break;
                }
                case HeaderFixedLength: {
                    while (i < b.length) {
                        if (this.receivedData.getSize() == 0) {
                            if (this.packetStartList != null) {
                                if (this.inList(b[i])) {
                                    this.receivedData.append(b[i]);
                                }
                            } else if ((byte)(b[i] & this.packetStartMask) == this.packetStart) {
                                this.receivedData.append(b[i]);
                            }
                        } else if (this.receivedData.getSize() > 0) {
                            this.receivedData.append(b[i]);
                            if (this.receivedData.getSize() >= this.packetLength) {
                                this.queue.add(this.receivedData.getAsArrayAndClear());
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case LongHeaderFixedLength: {
                    while (i < b.length) {
                        if (this.receivedData.getSize() < this.packetStartList.length) {
                            if (b[i] == this.packetStartList[this.receivedData.getSize()]) {
                                this.receivedData.append(b[i]);
                            } else {
                                this.receivedData.clear();
                            }
                        } else if (this.receivedData.getSize() > 0) {
                            this.receivedData.append(b[i]);
                            if (this.receivedData.getSize() >= this.packetLength) {
                                this.queue.add(this.receivedData.getAsArrayAndClear());
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case ModbusRTU: {
                    while (i < b.length) {
                        this.receivedData.append(b[i++]);
                        if (this.packetLength > 0 && this.receivedData.getSize() == this.packetLength) {
                            this.queue.add(this.receivedData.getAsArrayAndClear());
                            this.packetLength = 0;
                            continue;
                        }
                        if (this.receivedData.getSize() != 3) continue;
                        if ((this.receivedData.byteAt(1) & 0x80) != 0) {
                            this.packetLength = 5;
                            continue;
                        }
                        switch (this.receivedData.byteAt(1)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.packetLength = this.receivedData.unsignedByteAt(2) + 5;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 16: {
                                this.packetLength = 8;
                            }
                        }
                    }
                    break;
                }
                case ModbusKunkin: {
                    while (i < b.length) {
                        this.receivedData.append(b[i++]);
                        if (this.packetLength > 0 && this.receivedData.getSize() == this.packetLength) {
                            this.queue.add(this.receivedData.getAsArrayAndClear());
                            this.packetLength = 0;
                            continue;
                        }
                        if (this.receivedData.getSize() != 3) continue;
                        if ((this.receivedData.byteAt(1) & 0x80) != 0) {
                            this.packetLength = 5;
                            continue;
                        }
                        switch (this.receivedData.byteAt(1)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (this.receivedData.byteAt(1) == 3 && (this.receivedData.byteAt(2) == 48 || this.receivedData.byteAt(2) == 30)) {
                                    this.packetLength = 23;
                                    break;
                                }
                                if (this.receivedData.byteAt(1) == 3 && this.receivedData.byteAt(2) == 31) {
                                    this.packetLength = 37;
                                    break;
                                }
                                this.packetLength = this.receivedData.unsignedByteAt(2) + 5;
                                break;
                            }
                            case 6: {
                                this.packetLength = 13;
                                break;
                            }
                            case 5: 
                            case 16: {
                                this.packetLength = 8;
                            }
                        }
                    }
                    break;
                }
                case ModbusTCP: {
                    while (i < b.length) {
                        this.receivedData.append(b[i++]);
                        if (this.packetLength > 0 && this.receivedData.getSize() == this.packetLength) {
                            this.queue.add(this.receivedData.getAsArrayAndClear());
                            this.packetLength = 0;
                            continue;
                        }
                        if (this.receivedData.getSize() != 4) continue;
                        this.packetLength = (this.receivedData.unsignedByteAt(2) << 8) + this.receivedData.unsignedByteAt(3) + 6;
                    }
                    break;
                }
                case ATorch: {
                    while (i < b.length) {
                        byte c = b[i++];
                        if (this.packetLength > 0 && this.receivedData.getSize() == this.packetLength) {
                            this.queue.add(this.receivedData.getAsArrayAndClear());
                            this.packetLength = 0;
                            continue;
                        }
                        if (this.receivedData.getSize() == 0 && c != -1) continue;
                        if (this.receivedData.getSize() == 1 && c != 85) {
                            this.receivedData.clear();
                            continue;
                        }
                        this.receivedData.append(c);
                        if (this.receivedData.getSize() != 4) continue;
                        switch (this.receivedData.byteAt(2)) {
                            case 1: {
                                this.packetLength = 36;
                                break;
                            }
                            case 2: {
                                this.packetLength = 8;
                                break;
                            }
                            case 3: {
                                this.packetLength = 10;
                            }
                        }
                    }
                    break;
                }
                case Appa: {
                    while (i < b.length) {
                        byte c = b[i++];
                        if (this.receivedData.getSize() <= 0 && c != 85) continue;
                        this.receivedData.append(c);
                        if (this.packetLength == 0 && this.receivedData.getSize() == 4) {
                            this.packetLength = c + 5;
                            continue;
                        }
                        if (this.packetLength <= 0 || this.receivedData.getSize() != this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                        this.packetLength = 0;
                    }
                    break;
                }
                case Length7: {
                    while (i < b.length) {
                        byte c = b[i++];
                        if (this.packetLength == 0 && (c & 0x80) != 0) {
                            this.packetLength = c & 0x80;
                            this.receivedData.append(c);
                        } else if (this.packetLength > 0) {
                            this.receivedData.append(c);
                        }
                        if (this.packetLength <= 0 || this.receivedData.getSize() < this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                        this.packetLength = 0;
                    }
                    break;
                }
                case Length15: {
                    while (i < b.length) {
                        byte c = b[i++];
                        if (this.receivedData.getSize() == 0 && (c & 0x80) != 0) {
                            this.receivedData.append(c);
                        } else if (this.receivedData.getSize() > 0 && this.receivedData.getSize() < 2) {
                            this.receivedData.append(c);
                            if (this.receivedData.getSize() == 2) {
                                this.packetLength = 2 + ((this.receivedData.byteAt(0) & 0x7F) << 8 | this.receivedData.unsignedByteAt(1));
                            }
                        } else if (this.packetLength > 0) {
                            this.receivedData.append(c);
                        }
                        if (this.packetLength <= 0 || this.receivedData.getSize() < this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                        this.packetLength = 0;
                    }
                    break;
                }
                case Length31: {
                    while (i < b.length) {
                        byte c = b[i++];
                        if (this.receivedData.getSize() == 0 && (c & 0x80) != 0) {
                            this.receivedData.append(c);
                        } else if (this.receivedData.getSize() > 0 && this.receivedData.getSize() < 4) {
                            this.receivedData.append(c);
                            if (this.receivedData.getSize() == 4) {
                                this.packetLength = 4 + ((this.receivedData.byteAt(0) & 0x7F) << 24 | this.receivedData.unsignedByteAt(1) << 16 | this.receivedData.unsignedByteAt(2) << 8 | this.receivedData.unsignedByteAt(3));
                            }
                        } else if (this.packetLength > 0) {
                            this.receivedData.append(c);
                        }
                        if (this.packetLength <= 0 || this.receivedData.getSize() < this.packetLength) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                        this.packetLength = 0;
                    }
                    break;
                }
                case EndCRLF: {
                    while (i < b.length) {
                        this.receivedData.append(b[i++]);
                        if (this.receivedData.getSize() <= 2 || this.receivedData.byteAt(this.receivedData.getSize() - 2) != 13 || this.receivedData.byteAt(this.receivedData.getSize() - 1) != 10) continue;
                        this.queue.add(this.receivedData.getAsArrayAndClear());
                    }
                    break;
                }
                case HeaderAndEnd: {
                    while (i < b.length) {
                        if (this.receivedData.getSize() < this.packetStartList.length) {
                            if (b[i] == this.packetStartList[this.receivedData.getSize()]) {
                                this.receivedData.append(b[i]);
                                this.blockCounter = 0;
                            } else {
                                this.receivedData.clear();
                            }
                        } else {
                            this.receivedData.append(b[i]);
                            boolean done = true;
                            int j = 0;
                            while (j < this.packetEndList.length) {
                                if (this.receivedData.getSize() < this.packetEndList.length || this.packetEndList[j] != this.receivedData.byteAt(this.receivedData.getSize() - this.packetEndList.length + j)) {
                                    done = false;
                                }
                                ++j;
                            }
                            if (done) {
                                ++this.blockCounter;
                                if (this.blockCounter >= this.blockCount) {
                                    this.queue.add(this.receivedData.getAsArrayAndClear());
                                    this.blockCounter = 0;
                                }
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized byte[] writeReadData(byte[] data, int timeout) {
        this.writeData(data);
        return this.readData(timeout);
    }
}

