/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import dk.hkj.comm.SerialInterface;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class SerialLineInterface
extends SerialInterface
implements SerialPortDataListener {
    private boolean lastCharWasCR;
    private ByteBuffer receivedData = new ByteBuffer();
    private LinkedBlockingDeque<byte[]> queue = new LinkedBlockingDeque(1000);
    private boolean bin = false;

    SerialLineInterface(SerialPort p, boolean debugLog) {
        super(p);
        this.debugLog = debugLog;
    }

    @Override
    public synchronized boolean write(String msg) {
        int i;
        if (!this.serialPort.isOpen()) {
            return false;
        }
        byte[] b = (String.valueOf(msg) + this.eol).getBytes(this.charset);
        long time = System.currentTimeMillis();
        for (int n = 0; n < b.length; n += i) {
            i = this.serialPort.writeBytes(b, b.length - n, n);
            SerialInterface.sleep(1);
            if (i >= 0 && System.currentTimeMillis() - time <= (long)this.timeout) continue;
            System.out.println("Writing timeout");
            return i == b.length;
        }
        this.log("Tx:", msg);
        if (this.debugLog) {
            this.logLog("Tx: <" + StringUtil.printableString(String.valueOf(msg) + this.eol) + "> " + StringUtil.hexString(String.valueOf(msg) + this.eol));
        }
        return true;
    }

    @Override
    public String read() {
        return this.read(this.timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        try {
            byte[] b = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            if (b != null) {
                String s = new String(b, this.charset);
                this.log("Rx:", s);
                if (this.debugLog) {
                    this.logLog("Rx: <" + StringUtil.printableString(s) + "> " + StringUtil.hexString(s));
                }
                return s;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.debugLog) {
            if (this.receivedData.getSize() > 0) {
                this.logLog("Rx: timeout, in buffer: " + StringUtil.hexN(this.receivedData.getAsArray()));
            } else {
                this.logLog("Rx: timeout");
            }
        }
        return null;
    }

    @Override
    public synchronized String writeRead(String msg) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        return this.read();
    }

    @Override
    public synchronized String writeRead(String msg, int timeout) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        return this.read(timeout);
    }

    @Override
    public synchronized byte[] readBin(int count, int timeout) {
        if (!this.serialPort.isOpen()) {
            return null;
        }
        long time = System.currentTimeMillis();
        try {
            this.bin = true;
            while (this.receivedData.getSize() < count && System.currentTimeMillis() - time < (long)timeout) {
                SerialLineInterface.sleep(1);
            }
            if (this.debugLog) {
                this.logLog("RxBin: " + StringUtil.hexN(this.receivedData.getAsArray()));
            }
            byte[] byArray = this.receivedData.getAsArrayAndClear();
            return byArray;
        }
        finally {
            this.bin = false;
        }
    }

    private byte[] readBinLocal(int count, int timeout) {
        if (!this.serialPort.isOpen()) {
            return null;
        }
        long time = System.currentTimeMillis();
        int l = this.receivedData.getSize();
        while (this.receivedData.getSize() < count && System.currentTimeMillis() - time < (long)timeout) {
            SerialLineInterface.sleep(1);
            if (l == this.receivedData.getSize()) continue;
            l = this.receivedData.getSize();
            time = System.currentTimeMillis();
        }
        if (this.debugLog) {
            this.logLog("RxBin: " + StringUtil.hexN(this.receivedData.getAsArray()));
        }
        return this.receivedData.getAsArrayAndRemove(count);
    }

    @Override
    public synchronized byte[] readSCPIBinary(String cmd) {
        this.write(cmd);
        byte[] b = null;
        try {
            this.bin = true;
            b = this.readBinLocal(2, 3000);
            if (b == null || b[0] != 35 || b[1] < 48 || b[1] > 57) {
                return null;
            }
            b = this.readBinLocal(b[1] - 48, 3000);
            int n = 0;
            int i = 0;
            while (i < b.length) {
                n = n * 10 + (b[i] - 48);
                ++i;
            }
            b = this.readBinLocal(n, 3000);
            this.flush();
        }
        finally {
            this.bin = false;
        }
        return b;
    }

    @Override
    public synchronized boolean isData() {
        return this.queue.size() > 0;
    }

    @Override
    public synchronized byte[] writeReadBin(String msg, int count, int timeout) {
        if (!this.serialPort.isOpen()) {
            return null;
        }
        byte[] b = msg == null ? null : msg.getBytes(this.charset);
        long time = System.currentTimeMillis();
        this.receivedData.clear();
        try {
            this.bin = true;
            if (b != null) {
                int i;
                for (int n = 0; n < b.length; n += i) {
                    i = this.serialPort.writeBytes(b, b.length - n, n);
                    SerialInterface.sleep(1);
                    if (i >= 0 && System.currentTimeMillis() - time <= (long)timeout) continue;
                    System.out.println("Writing timeout");
                    return null;
                }
                this.log("TxBin:", msg);
                if (this.debugLog) {
                    this.logLog("TxBin: <" + StringUtil.printableString(msg) + "> " + StringUtil.hexString(msg));
                }
            }
            while (this.receivedData.getSize() < count && System.currentTimeMillis() - time < (long)timeout) {
                SerialLineInterface.sleep(1);
            }
            if (this.debugLog) {
                this.logLog("RxBin: " + StringUtil.hexN(this.receivedData.getAsArray()));
            }
            byte[] byArray = this.receivedData.getAsArrayAndClear();
            return byArray;
        }
        finally {
            this.bin = false;
        }
    }

    @Override
    public synchronized boolean writeBin(String msg) {
        byte[] b;
        if (!this.serialPort.isOpen()) {
            return false;
        }
        try {
            b = msg == null ? null : msg.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            b = msg.getBytes();
        }
        long time = System.currentTimeMillis();
        this.receivedData.clear();
        try {
            this.bin = true;
            if (b != null) {
                int i;
                for (int n = 0; n < b.length; n += i) {
                    i = this.serialPort.writeBytes(b, b.length - n, n);
                    SerialInterface.sleep(1);
                    if (i >= 0 && System.currentTimeMillis() - time <= (long)this.timeout) continue;
                    System.out.println("Writing timeout");
                    return false;
                }
                this.log("TxBin:", msg);
                if (this.debugLog) {
                    this.logLog("TxBin: <" + StringUtil.printableString(msg) + "> " + StringUtil.hexString(msg));
                }
            }
            return true;
        }
        finally {
            this.bin = false;
        }
    }

    @Override
    public synchronized void flush() {
        this.queue.clear();
        this.receivedData.clear();
    }

    @Override
    public int getListeningEvents() {
        return 17;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        try {
            byte[] b = event.getReceivedData();
            int i = 0;
            while (i < b.length) {
                byte[] s;
                if (this.bin) {
                    this.receivedData.append(b[i]);
                } else if (b[i] == 13) {
                    this.lastCharWasCR = true;
                    s = this.receivedData.getAsArrayAndClear();
                    this.queue.add(s);
                } else if (b[i] == 10) {
                    if (!this.lastCharWasCR) {
                        s = this.receivedData.getAsArrayAndClear();
                        this.queue.add(s);
                    }
                    this.lastCharWasCR = false;
                } else if (b[i] >= 32 || b[i] < 0) {
                    this.receivedData.append(b[i]);
                    this.lastCharWasCR = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

