/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialLineInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class SerialInterface
extends CommInterface
implements SerialPortDataListener {
    protected SerialPort serialPort = null;

    public static String formatSettingString(String settings) {
        return new PortSettings(settings).toString();
    }

    SerialInterface(SerialPort p) {
        this.serialPort = p;
        this.serialPort.setFlowControl(0);
        this.serialPort.addDataListener(this);
    }

    @Override
    public String getAddress() {
        return this.serialPort.getSystemPortName();
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.Serial;
    }

    public SerialLineInterface getSerialLineInterface() {
        this.serialPort.removeDataListener();
        SerialLineInterface sli = new SerialLineInterface(this.serialPort, this.debugLog);
        this.serialPort = null;
        return sli;
    }

    @Override
    public SerialPacketInterface getDataInterface() {
        this.serialPort.removeDataListener();
        SerialPacketInterface spi = new SerialPacketInterface(this.serialPort, this.debugLog);
        this.serialPort = null;
        return spi;
    }

    @Override
    public String getName() {
        return String.valueOf(this.serialPort.getPortDescription()) + " (" + this.serialPort.getSystemPortName() + ")";
    }

    @Override
    public String getDeviceName() {
        return this.serialPort.getSystemPortName();
    }

    @Override
    public synchronized void open() {
        if (this.serialPort.isOpen()) {
            return;
        }
        this.serialPort.openPort();
        if (this.serialPort.isOpen()) {
            this.log("Open");
            this.serialPort.setComPortTimeouts(0, 100, 100);
        } else {
            this.log("Port failed to open");
        }
    }

    public synchronized void setControl(boolean rts, boolean dtr) {
        if (this.debugLog) {
            this.logLog("Set rts:" + rts + " dtr:" + dtr);
        }
        if (rts) {
            this.serialPort.setRTS();
        } else {
            this.serialPort.clearRTS();
        }
        if (dtr) {
            this.serialPort.setDTR();
        } else {
            this.serialPort.clearDTR();
        }
    }

    @Override
    public synchronized void close() {
        this.serialPort.closePort();
        if (this.debugLog) {
            this.logLog("Close");
        }
        this.log("Closing port");
    }

    private synchronized void setParams(int baudrate, int dataBits, int stopBits, int parity) {
        this.serialPort.setComPortParameters(baudrate, dataBits, stopBits, parity);
    }

    @Override
    public void setParams(String params) {
        PortSettings ps = new PortSettings(params);
        this.setParams(ps.baud, ps.dataBits, ps.stopBits, ps.parity);
        if (ps.rts == 1) {
            this.serialPort.setRTS();
        }
        if (ps.rts == -1) {
            this.serialPort.clearRTS();
        }
        if (ps.dtr == 1) {
            this.serialPort.setDTR();
        }
        if (ps.dtr == -1) {
            this.serialPort.clearDTR();
        }
        if (ps.rts == 2) {
            this.serialPort.setFlowControl(1);
        }
        if (ps.dtr == 2) {
            this.serialPort.setFlowControl(4096);
        }
        if (this.debugLog) {
            this.logLog("Set params: " + ps.toString());
        }
        this.log("Baudrate: " + ps.toString());
    }

    public void setRTS(boolean on) {
        if (!this.isOpen()) {
            return;
        }
        if (on) {
            this.serialPort.setRTS();
        } else {
            this.serialPort.clearRTS();
        }
    }

    public void setDTR(boolean on) {
        if (!this.isOpen()) {
            return;
        }
        if (on) {
            this.serialPort.setDTR();
        } else {
            this.serialPort.clearDTR();
        }
    }

    @Override
    public boolean isOpen() {
        return this.serialPort != null && this.serialPort.isOpen();
    }

    public static List<CommInterface> getSerialPorts(String portMask, boolean debugLog) {
        if (debugLog) {
            InterfaceThreads.logDebug("jSerialComm version: " + SerialPort.getVersion());
        }
        ArrayList<CommInterface> ports = new ArrayList<CommInterface>();
        Pattern mask = Pattern.compile(portMask);
        SerialPort[] serialPortArray = SerialPort.getCommPorts();
        int n = serialPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            SerialPort p = serialPortArray[n2];
            if (mask.matcher(p.getPortDescription()).matches() || mask.matcher(p.getSystemPortName()).matches() || mask.matcher(p.getPortDescription()).matches()) {
                ports.add(new SerialLineInterface(p, debugLog));
            }
            ++n2;
        }
        ports.sort(null);
        return ports;
    }

    @Override
    public int getSerialId() {
        if (!this.isOpen()) {
            return -1;
        }
        int n = 0;
        if (this.serialPort != null) {
            String s = this.serialPort.getSystemPortName();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    n = n * 10 + (c - 48);
                }
                ++i;
            }
        }
        return n % 100;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.serialPort.getSystemPortName();
    }

    private static class PortSettings {
        private static final String defaultBaudParams = "N81";
        protected int baud = 9600;
        protected int parity = 0;
        protected int dataBits = 8;
        protected int stopBits = 1;
        protected int dtr = 0;
        protected int rts = 0;

        public PortSettings(String settings) {
            if (settings != null) {
                int i = 0;
                int n = 0;
                while (i < settings.length() && Character.isDigit(settings.charAt(i))) {
                    n = n * 10 + (settings.charAt(i) - 48);
                    ++i;
                }
                this.baud = n;
                while (i < settings.length() && settings.charAt(i) == ' ') {
                    ++i;
                }
                if (i < settings.length() && "EOMSN".indexOf(Character.toUpperCase(settings.charAt(i))) >= 0) {
                    switch (Character.toUpperCase(settings.charAt(i))) {
                        case 'E': {
                            this.parity = 2;
                            break;
                        }
                        case 'O': {
                            this.parity = 1;
                            break;
                        }
                        case 'M': {
                            this.parity = 3;
                            break;
                        }
                        case 'S': {
                            this.parity = 4;
                            break;
                        }
                        case 'N': {
                            this.parity = 0;
                        }
                    }
                    ++i;
                }
                while (i < settings.length() && settings.charAt(i) == ' ') {
                    ++i;
                }
                if (i < settings.length() && settings.charAt(i) == '7') {
                    this.dataBits = 7;
                    ++i;
                } else if (i < settings.length() && settings.charAt(i) == '8') {
                    this.dataBits = 8;
                    ++i;
                }
                while (i < settings.length() && settings.charAt(i) == ' ') {
                    ++i;
                }
                if (i < settings.length() && settings.charAt(i) == '1') {
                    this.stopBits = 1;
                    if (++i < settings.length() && settings.charAt(i) == '.') {
                        this.stopBits = 2;
                        i += 2;
                    }
                } else if (i < settings.length() && settings.charAt(i) == '2') {
                    this.stopBits = 3;
                    ++i;
                }
                while (i < settings.length() && "rdRDhH -".indexOf(settings.charAt(i)) >= 0) {
                    switch (settings.charAt(i)) {
                        case 'r': {
                            this.rts = -1;
                            break;
                        }
                        case 'R': {
                            this.rts = 1;
                            break;
                        }
                        case 'd': {
                            this.dtr = -1;
                            break;
                        }
                        case 'D': {
                            this.dtr = 1;
                            break;
                        }
                        case 'H': {
                            this.dtr = 2;
                            break;
                        }
                        case 'h': {
                            this.rts = 2;
                        }
                    }
                    ++i;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.baud);
            switch (this.parity) {
                case 2: {
                    sb.append("E");
                    break;
                }
                case 1: {
                    sb.append("O");
                    break;
                }
                case 3: {
                    sb.append("M");
                    break;
                }
                case 4: {
                    sb.append("S");
                    break;
                }
                case 0: {
                    sb.append("N");
                }
            }
            sb.append(this.dataBits);
            switch (this.stopBits) {
                case 1: {
                    sb.append('1');
                    break;
                }
                case 3: {
                    sb.append('2');
                    break;
                }
                case 2: {
                    sb.append("1.5");
                }
            }
            if (this.rts == 1) {
                sb.append("R");
            }
            if (this.rts == -1) {
                sb.append("r");
            }
            if (this.dtr == 1) {
                sb.append("D");
            }
            if (this.dtr == -1) {
                sb.append("d");
            }
            if (this.rts == 2) {
                sb.append("h");
            }
            if (this.dtr == 2) {
                sb.append("H");
            }
            if (sb.toString().endsWith(defaultBaudParams)) {
                sb.setLength(sb.length() - defaultBaudParams.length());
            }
            return sb.toString();
        }
    }
}

