/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.util.ByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class RPC {
    private Socket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    private String port = "";
    private String host = "";
    private int prog;
    private int vers;
    private int proc;
    private List<Integer> params = null;
    private int xid = 0;
    private byte[] answer = null;
    private int[] answerParams = null;

    public int portmapGetport(int prog, int vers, int protocol, int port) {
        this.defineCall(100000, 2, 3);
        this.addParam(prog);
        this.addParam(vers);
        this.addParam(protocol);
        this.addParam(port);
        if (this.doCall(1000) && this.decodeAnswer()) {
            this.close();
            return this.answerParams[0];
        }
        this.close();
        return 0;
    }

    public void defineCall(int prog, int vers, int proc) {
        this.defineCall(prog, vers, proc, null);
    }

    public void defineCall(int prog, int vers, int proc, int[] params) {
        this.params = null;
        this.prog = prog;
        this.vers = vers;
        this.proc = proc;
        if (params != null && params.length > 0) {
            this.params = new ArrayList<Integer>();
            int[] nArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.params.add(i);
                ++n2;
            }
        }
    }

    private int getIntFromAnswer(int offset) {
        return ((this.answer[offset] & 0xFF) << 24) + ((this.answer[offset + 1] & 0xFF) << 16) + ((this.answer[offset + 2] & 0xFF) << 8) + (this.answer[offset + 3] & 0xFF);
    }

    public int getAnswer(int index) {
        if (this.answerParams == null || this.answerParams.length < index) {
            return 0;
        }
        return this.answerParams[index];
    }

    public boolean decodeAnswer() {
        int size = this.getIntFromAnswer(0) & Integer.MAX_VALUE;
        this.getIntFromAnswer(4);
        if (this.getIntFromAnswer(8) != 1) {
            return false;
        }
        this.getIntFromAnswer(12);
        this.getIntFromAnswer(24);
        int n = (size - 24) / 4;
        this.answerParams = new int[n];
        int i = 0;
        while (i < n) {
            this.answerParams[i] = this.getIntFromAnswer(28 + i * 4);
            ++i;
        }
        return true;
    }

    public void addParam(int i) {
        if (this.params == null) {
            this.params = new ArrayList<Integer>();
        }
        this.params.add(i);
    }

    public void addParam(String s) {
        if (this.params == null) {
            this.params = new ArrayList<Integer>();
        }
        this.params.add(s.length());
        int index = 0;
        int i = 0;
        while (i < (s.length() + 3) / 4) {
            int v = 0;
            int j = 0;
            while (j < 4) {
                v = index < s.length() ? (v << 8) + (s.charAt(index++) & 0xFF) : (v <<= 8);
                ++j;
            }
            this.params.add(v);
            ++i;
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean doCall(int timeout) {
        this.answerParams = null;
        this.answer = null;
        if (this.socket == null && !this.connect()) {
            return false;
        }
        try {
            this.os.write(this.getData());
            ByteBuffer bb = new ByteBuffer();
            while (timeout > 0 && this.is.available() < 10) {
                this.sleep(10);
                timeout -= 10;
            }
            do {
                byte[] buffer = new byte[1000];
                int n = this.is.read(buffer);
                bb.append(buffer, 0, n);
                this.sleep(5);
            } while (this.is.available() > 0);
            this.answer = bb.getAsArray();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    byte[] getData() {
        ByteBuffer bb = new ByteBuffer();
        this.xid = (int)(Math.random() * 2.147483647E9);
        bb.appendMsbFirst(this.xid);
        bb.appendMsbFirst(0);
        bb.appendMsbFirst(2);
        bb.appendMsbFirst(this.prog);
        bb.appendMsbFirst(this.vers);
        bb.appendMsbFirst(this.proc);
        bb.appendMsbFirst(0);
        bb.appendMsbFirst(0);
        bb.appendMsbFirst(0);
        bb.appendMsbFirst(0);
        if (this.params != null) {
            for (int i : this.params) {
                bb.appendMsbFirst(i);
            }
        }
        bb.insertMsbFirst(0, (int)(0x80000000L + (long)bb.getSize()));
        return bb.getAsArray();
    }

    public synchronized void close() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {}
            this.os = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
            this.is = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
        }
    }

    public RPC(String address, int defPort) {
        this.port = "" + defPort;
        this.parseAddress(address);
    }

    public RPC(String address) {
        this.parseAddress(address);
    }

    public RPC(String address, String defPort) {
        this.port = defPort;
        this.parseAddress(address);
    }

    private void parseAddress(String address) {
        int i = address.indexOf(58);
        if (i > 0) {
            this.port = address.substring(i + 1);
            address = address.substring(i);
        }
        this.host = address.trim();
    }

    public synchronized boolean connect() {
        int portnum = 80;
        portnum = this.port.equals("ftp") ? 21 : (this.port.equals("ssh") ? 22 : (this.port.equals("telnet") ? 23 : (this.port.equals("smtp") ? 25 : (this.port.equals("http") ? 80 : (this.port.equals("telnet") ? 23 : Integer.valueOf(this.port))))));
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, portnum), 500);
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public synchronized boolean isOpen() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isOutputShutdown() && !this.socket.isInputShutdown();
    }

    long getSocketIp() {
        if (!this.isOpen()) {
            return -1L;
        }
        byte[] adr = this.socket.getInetAddress().getAddress();
        long n = 0L;
        int i = 0;
        while (i < adr.length) {
            n = n * 256L + (long)adr[i];
            ++i;
        }
        return n;
    }
}

