/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.LXIInterface;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;

public class LXIPacketInterface
extends LXIInterface
implements CommDataInterface {
    private int packetLength = 0;
    private byte packetStart = 0;
    private byte[] packetStartList = null;
    private byte[] packetEndList = null;
    private byte packetStartMask = 0;
    private CommDataInterface.PacketFormat packetFormat;
    private ByteBuffer bb = new ByteBuffer();

    protected LXIPacketInterface(String address) {
        super(address);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat) {
        this.packetFormat = packetFormat;
        this.packetStart = 0;
        this.packetStartMask = 0;
        this.packetLength = 0;
        this.bb.setLength(0);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetStart = 0;
        this.packetStartMask = 0;
        this.packetLength = packetLength;
        this.bb.setLength(0);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetStart = packetStart;
        this.packetStartMask = (byte)-1;
        this.packetLength = packetLength;
        this.bb.setLength(0);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, byte packetStartMask, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = null;
        this.packetStart = packetStart;
        this.packetStartMask = packetStartMask;
        this.packetLength = packetLength;
        this.bb.setLength(0);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, int packetLength) {
        this.packetFormat = packetFormat;
        this.packetStartList = packetStart;
        this.packetStart = packetStart[0];
        this.packetStartMask = (byte)-1;
        this.packetLength = packetLength;
        this.bb.setLength(0);
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, byte[] packetEnd, int count) {
        this.packetFormat = packetFormat;
        this.packetStartList = packetStart;
        this.packetEndList = packetEnd;
        this.packetStart = packetStart[0];
        this.packetStartMask = (byte)-1;
        this.packetLength = 0;
        this.bb.setLength(0);
    }

    @Override
    public synchronized boolean writeData(byte[] data) {
        if (!this.isOpen()) {
            return false;
        }
        if (this.debugLog) {
            this.logLog("Tx: " + StringUtil.hexN(data));
        }
        try {
            this.write(new String(data, this.charset));
        }
        catch (Exception exception) {
            this.close();
            return false;
        }
        return true;
    }

    private boolean inList(byte b) {
        byte[] byArray = this.packetStartList;
        int n = this.packetStartList.length;
        int n2 = 0;
        while (n2 < n) {
            byte bb = byArray[n2];
            if (b == bb) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public synchronized byte[] readData(int timeout) {
        if (this.packetFormat == null) {
            return null;
        }
        this.bb.clear();
        try {
            byte[] data = this.readBin(timeout);
            int i = 0;
            while (i < data.length) {
                byte b = data[i];
                switch (this.packetFormat) {
                    case HeaderFixedLength: {
                        if (this.bb.getSize() == 0) {
                            if (this.packetStartList != null) {
                                if (!this.inList(b)) break;
                                this.bb.append(b);
                                break;
                            }
                            if ((byte)(b & this.packetStartMask) != this.packetStart) break;
                            this.bb.append(b);
                            break;
                        }
                        if (this.bb.getSize() <= 0) break;
                        this.bb.append(b);
                        if (this.bb.getSize() < this.packetLength) break;
                        if (this.debugLog) {
                            this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                        }
                        return this.bb.getAsArrayAndClear();
                    }
                    case ModbusRTU: {
                        this.bb.append(b);
                        if (this.packetLength > 0 && this.bb.getSize() == this.packetLength) {
                            this.packetLength = 0;
                            if (this.debugLog) {
                                this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                            }
                            return this.bb.getAsArrayAndClear();
                        }
                        if (this.bb.getSize() != 3) break;
                        if ((this.bb.byteAt(1) & 0x80) != 0) {
                            this.packetLength = 5;
                            break;
                        }
                        switch (this.bb.byteAt(1)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.packetLength = this.bb.unsignedByteAt(2) + 5;
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 16: {
                                this.packetLength = 8;
                            }
                        }
                        break;
                    }
                    case ModbusTCP: {
                        this.bb.append(b);
                        if (this.packetLength > 0 && this.bb.getSize() == this.packetLength) {
                            this.packetLength = 0;
                            if (this.debugLog) {
                                this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                            }
                            return this.bb.getAsArrayAndClear();
                        }
                        if (this.bb.getSize() != 6) break;
                        this.packetLength = (this.bb.unsignedByteAt(4) << 8) + this.bb.unsignedByteAt(5) + 6;
                        break;
                    }
                    case Length7: {
                        if (this.packetLength == 0 && (b & 0x80) != 0) {
                            this.packetLength = b & 0x80;
                            this.bb.append(b);
                        } else if (this.packetLength > 0) {
                            this.bb.append(b);
                        }
                        if (this.packetLength <= 0 || this.bb.getSize() < this.packetLength) break;
                        this.packetLength = 0;
                        if (this.debugLog) {
                            this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                        }
                        return this.bb.getAsArrayAndClear();
                    }
                    case Length15: {
                        if (this.bb.getSize() == 0 && (b & 0x80) != 0) {
                            this.bb.append(b);
                        } else if (this.bb.getSize() > 0 && this.bb.getSize() < 2) {
                            this.bb.append(b);
                            if (this.bb.getSize() == 2) {
                                this.packetLength = 2 + ((this.bb.byteAt(0) & 0x7F) << 8 | this.bb.unsignedByteAt(1));
                            }
                        } else if (this.packetLength > 0) {
                            this.bb.append(b);
                        }
                        if (this.packetLength <= 0 || this.bb.getSize() < this.packetLength) break;
                        this.packetLength = 0;
                        if (this.debugLog) {
                            this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                        }
                        return this.bb.getAsArrayAndClear();
                    }
                    case Length31: {
                        if (this.bb.getSize() == 0 && (b & 0x80) != 0) {
                            this.bb.append(b);
                        } else if (this.bb.getSize() > 0 && this.bb.getSize() < 4) {
                            this.bb.append(b);
                            if (this.bb.getSize() == 4) {
                                this.packetLength = 4 + ((this.bb.byteAt(0) & 0x7F) << 24 | this.bb.unsignedByteAt(1) << 16 | this.bb.unsignedByteAt(2) << 8 | this.bb.unsignedByteAt(3));
                            }
                        } else if (this.packetLength > 0) {
                            this.bb.append(b);
                        }
                        if (this.packetLength <= 0 || this.bb.getSize() < this.packetLength) break;
                        this.packetLength = 0;
                        if (this.debugLog) {
                            this.logLog("Rx: " + StringUtil.hexN(this.bb.getAsArray()));
                        }
                        return this.bb.getAsArrayAndClear();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.debugLog) {
            this.logLog("Rx fail " + timeout + "ms   In buffer: " + StringUtil.hexN(this.bb.getAsArray()));
        }
        return null;
    }

    @Override
    public byte[] readData() {
        return this.readData(this.timeout);
    }

    @Override
    public byte[] writeReadData(byte[] data) {
        return this.writeReadData(data, this.timeout);
    }

    @Override
    public synchronized byte[] writeReadData(byte[] data, int timeout) {
        this.writeData(data);
        return this.readData(timeout);
    }

    @Override
    public void setAnswerTimeout(int timeout) {
    }

    @Override
    public synchronized boolean write(String msg) {
        return false;
    }

    @Override
    public synchronized boolean isData() {
        return false;
    }

    @Override
    public synchronized String read(int timeout) {
        return null;
    }
}

