/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LXIInterface;
import dk.hkj.comm.LXIPacketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import java.util.HashMap;
import java.util.Map;

public class LXIInterfaceMulti
extends CommInterface {
    private String address = null;
    private int port = 0;
    private Map<Integer, LXIInterface> map = new HashMap<Integer, LXIInterface>();

    public LXIInterfaceMulti(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.LXI;
    }

    @Override
    public LXIPacketInterface getDataInterface() {
        this.map.get(this.port).close();
        LXIPacketInterface spi = new LXIPacketInterface(this.address);
        this.map.put(this.port, spi);
        return spi;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public synchronized void open() {
        if (this.map.get(this.port) != null) {
            this.map.get(this.port).close();
            this.map.remove(this.port);
        }
        LXIInterface lxi = new LXIInterface(this.address);
        lxi.setPort(this.port);
        lxi.open();
        this.map.put(this.port, lxi);
    }

    @Override
    public synchronized boolean write(String cmd) {
        return this.map.get(this.port).write(cmd);
    }

    public synchronized boolean deviceClear() {
        return this.map.get(this.port).deviceClear();
    }

    protected synchronized byte[] readBin(int timeout) {
        return this.map.get(this.port).readBin(timeout);
    }

    @Override
    public synchronized byte[] readBin(int count, int timeout) {
        return this.map.get(this.port).readBin(count, timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        return this.map.get(this.port).read(timeout);
    }

    public synchronized String readxx(int timeout) {
        return this.map.get(this.port).readxx(timeout);
    }

    @Override
    public synchronized String writeRead(String cmd) {
        return this.map.get(this.port).writeRead(cmd);
    }

    public synchronized boolean destroyLink() {
        return this.map.get(this.port).destroyLink();
    }

    @Override
    public synchronized void close() {
        if (this.map.get(this.port) != null) {
            this.map.get(this.port).close();
            this.map.remove(this.port);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized boolean isData() {
        return this.map.get(this.port).isData();
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public String read() {
        return this.map.get(this.port).read();
    }

    @Override
    public boolean isOpen() {
        if (this.map.get(this.port) == null) {
            return false;
        }
        return this.map.get(this.port).isOpen();
    }

    @Override
    public int getSerialId() {
        return this.map.get(this.port).getSerialId();
    }

    public static void main1(String[] args) {
        LXIInterfaceMulti lxi = new LXIInterfaceMulti("10.0.0.75");
        lxi.open();
        lxi.deviceClear();
        System.out.println("volt=" + lxi.writeRead(":volt 10;"));
        System.out.println("curr=" + lxi.writeRead(":curr 1.5;"));
        System.out.println("output=" + lxi.writeRead(":output:state 1;"));
        System.out.println("trig1=" + lxi.writeRead(":arm:sour imm;:arm:count 1;"));
        System.out.println("trig2=" + lxi.writeRead(":trig:sour imm;:trig:count 1;:trig:samp:count 1"));
        System.out.println("Read=" + lxi.writeRead(":read?"));
        lxi.close();
    }
}

