/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LXIPacketInterface;
import dk.hkj.comm.RPC;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;

public class LXIInterface
extends CommInterface {
    static final int VXI_11_Core = 395183;
    static final int VXI_11_CreateLink = 10;
    static final int VXI_11_DeviceClear = 15;
    static final int VXI_11_DeviceWrite = 11;
    static final int VXI_11_DeviceRead = 12;
    static final int VXI_11_DestroyLink = 23;
    private String address = null;
    private RPC rpc = null;
    private RPC lxirpc = null;
    private int linkId = 0;
    private ByteBuffer bb = new ByteBuffer();
    private int scpiPort = 0;

    public LXIInterface(String address) {
        this.address = address;
        this.rpc = new RPC(address, "111");
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.LXI;
    }

    public void setPort(int scpiPort) {
        this.scpiPort = scpiPort;
    }

    @Override
    public LXIPacketInterface getDataInterface() {
        this.close();
        LXIPacketInterface spi = new LXIPacketInterface(this.address);
        return spi;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public synchronized void open() {
        int port = this.rpc.portmapGetport(395183, 1, 6, this.scpiPort);
        this.lxirpc = new RPC(this.address, port);
        this.lxirpc.defineCall(395183, 1, 10);
        int clientId = 10;
        this.lxirpc.addParam(clientId);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam("inst0");
        if (!this.lxirpc.doCall(1000)) {
            return;
        }
        if (!this.lxirpc.decodeAnswer()) {
            return;
        }
        this.linkId = this.lxirpc.getAnswer(1);
        this.lxirpc.getAnswer(2);
        this.lxirpc.getAnswer(3);
        this.bb.clear();
    }

    @Override
    public synchronized boolean write(String cmd) {
        this.bb.clear();
        this.log("TX", cmd);
        this.lxirpc.defineCall(395183, 1, 11);
        this.lxirpc.addParam(this.linkId);
        this.lxirpc.addParam(3000);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(8);
        this.lxirpc.addParam(String.valueOf(cmd) + this.eol);
        return this.lxirpc.doCall(2000) && this.lxirpc.decodeAnswer();
    }

    public synchronized boolean deviceClear() {
        this.lxirpc.defineCall(395183, 1, 15);
        this.lxirpc.addParam(this.linkId);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(0);
        this.lxirpc.addParam(2000);
        return this.lxirpc.doCall(1000) && this.lxirpc.decodeAnswer();
    }

    protected synchronized byte[] readBin(int timeout) {
        this.bb.clear();
        int n = 0;
        do {
            this.lxirpc.defineCall(395183, 1, 12);
            this.lxirpc.addParam(this.linkId);
            this.lxirpc.addParam(1000);
            this.lxirpc.addParam(3000);
            this.lxirpc.addParam(2000);
            this.lxirpc.addParam(128);
            this.lxirpc.addParam(10);
            if (!this.lxirpc.doCall(3000)) {
                return null;
            }
            if (!this.lxirpc.decodeAnswer()) {
                return null;
            }
            int size = this.lxirpc.getAnswer(2);
            if (size == 0) {
                ++n;
            }
            int i = 0;
            while (i < size) {
                int c = this.lxirpc.getAnswer(3 + i / 4);
                switch (i % 4) {
                    case 0: {
                        this.bb.append((byte)(c >> 24 & 0xFF));
                        break;
                    }
                    case 1: {
                        this.bb.append((byte)(c >> 16 & 0xFF));
                        break;
                    }
                    case 2: {
                        this.bb.append((byte)(c >> 8 & 0xFF));
                        break;
                    }
                    case 3: {
                        this.bb.append((byte)(c & 0xFF));
                    }
                }
                ++i;
            }
        } while ((this.lxirpc.getAnswer(1) & 4) == 0 && n < 4);
        return this.bb.getAsArray();
    }

    @Override
    public synchronized byte[] readBin(int count, int timeout) {
        if (this.bb.getSize() >= count) {
            byte[] b = this.bb.getAsArray(0, count);
            this.bb.delete(0, count);
            return b;
        }
        int n = 0;
        do {
            this.lxirpc.defineCall(395183, 1, 12);
            this.lxirpc.addParam(this.linkId);
            this.lxirpc.addParam(1000);
            this.lxirpc.addParam(3000);
            this.lxirpc.addParam(2000);
            this.lxirpc.addParam(128);
            this.lxirpc.addParam(10);
            if (!this.lxirpc.doCall(3000)) {
                return null;
            }
            if (!this.lxirpc.decodeAnswer()) {
                return null;
            }
            int size = this.lxirpc.getAnswer(2);
            if (size == 0) {
                ++n;
            }
            int i = 0;
            while (i < size) {
                int c = this.lxirpc.getAnswer(3 + i / 4);
                switch (i % 4) {
                    case 0: {
                        this.bb.append((byte)(c >> 24 & 0xFF));
                        break;
                    }
                    case 1: {
                        this.bb.append((byte)(c >> 16 & 0xFF));
                        break;
                    }
                    case 2: {
                        this.bb.append((byte)(c >> 8 & 0xFF));
                        break;
                    }
                    case 3: {
                        this.bb.append((byte)(c & 0xFF));
                    }
                }
                ++i;
            }
        } while ((this.lxirpc.getAnswer(1) & 4) == 0 && n < 4);
        byte[] b = this.bb.getAsArray(0, count);
        this.bb.delete(0, count);
        return b;
    }

    @Override
    public synchronized String read(int timeout) {
        byte[] bb = this.readBin(timeout);
        String answer = new String(bb, this.charset);
        this.log("Rx", answer);
        return answer;
    }

    public synchronized String readxx(int timeout) {
        this.bb.clear();
        StringBuilder sb = new StringBuilder();
        int n = 0;
        do {
            this.lxirpc.defineCall(395183, 1, 12);
            this.lxirpc.addParam(this.linkId);
            this.lxirpc.addParam(1000);
            this.lxirpc.addParam(3000);
            this.lxirpc.addParam(2000);
            this.lxirpc.addParam(128);
            this.lxirpc.addParam(10);
            if (!this.lxirpc.doCall(3000)) {
                return null;
            }
            if (!this.lxirpc.decodeAnswer()) {
                return null;
            }
            int size = this.lxirpc.getAnswer(2);
            if (size == 0) {
                ++n;
            }
            int i = 0;
            while (i < size) {
                int c = this.lxirpc.getAnswer(3 + i / 4);
                switch (i % 4) {
                    case 0: {
                        sb.append((char)(c >> 24 & 0xFF));
                        break;
                    }
                    case 1: {
                        sb.append((char)(c >> 16 & 0xFF));
                        break;
                    }
                    case 2: {
                        sb.append((char)(c >> 8 & 0xFF));
                        break;
                    }
                    case 3: {
                        sb.append((char)(c & 0xFF));
                    }
                }
                ++i;
            }
        } while ((this.lxirpc.getAnswer(1) & 4) == 0 && n < 4);
        String answer = sb.toString();
        this.log("Rx", answer);
        return answer;
    }

    @Override
    public synchronized String writeRead(String cmd) {
        int a;
        this.bb.clear();
        if (!this.write(cmd)) {
            this.log("Failed to write " + cmd + " to lxi");
        }
        if ((a = this.lxirpc.getAnswer(1)) == 6 || a == 7 || a == 11 || a == 9 || a == 5) {
            String answer = this.read();
            return answer;
        }
        return null;
    }

    public synchronized boolean destroyLink() {
        this.lxirpc.defineCall(395183, 1, 23);
        this.lxirpc.addParam(this.linkId);
        this.linkId = 0;
        return this.lxirpc.doCall(1000) && this.lxirpc.decodeAnswer();
    }

    @Override
    public synchronized void close() {
        try {
            if (this.linkId != 0) {
                this.destroyLink();
            }
            if (this.lxirpc != null) {
                this.lxirpc.close();
                this.lxirpc = null;
            }
            if (this.rpc != null) {
                this.rpc.close();
                this.rpc = null;
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized boolean isData() {
        return false;
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public String read() {
        return this.read(1000);
    }

    @Override
    public boolean isOpen() {
        return this.lxirpc != null && this.lxirpc.isOpen();
    }

    @Override
    public int getSerialId() {
        if (!this.isOpen()) {
            return -1;
        }
        return (int)(this.lxirpc.getSocketIp() % 100L);
    }

    public static void main1(String[] args) {
        LXIInterface lxi = new LXIInterface("10.0.0.75");
        lxi.open();
        lxi.deviceClear();
        System.out.println("volt=" + lxi.writeRead(":volt 10;"));
        System.out.println("curr=" + lxi.writeRead(":curr 1.5;"));
        System.out.println("output=" + lxi.writeRead(":output:state 1;"));
        System.out.println("trig1=" + lxi.writeRead(":arm:sour imm;:arm:count 1;"));
        System.out.println("trig2=" + lxi.writeRead(":trig:sour imm;:trig:count 1;:trig:samp:count 1"));
        System.out.println("Read=" + lxi.writeRead(":read?"));
        lxi.close();
    }
}

