/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.devices.LoadDeviceConfig;
import java.io.UnsupportedEncodingException;

public abstract class HidClass
extends CommInterface
implements CommDataInterface {
    protected int vendor = 0;
    protected int product = 0;
    protected String usbSerialNo = null;
    protected LoadDeviceConfig.LoadDevice ld = null;

    @Override
    public String getAddress() {
        return this.usbSerialNo == null ? "" : this.usbSerialNo;
    }

    protected long usbSerialNoAsLong() {
        byte[] b;
        if (this.usbSerialNo.length() == 0) {
            return 0L;
        }
        long n = 0L;
        try {
            b = this.usbSerialNo.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0L;
        }
        int i = 0;
        while (i < b.length) {
            n += (long)((b[i] & 0xFF) << i * 8 % 64);
            ++i;
        }
        if (n < 0L) {
            n = -n;
        }
        return n;
    }

    protected String usbSerialNoAsAddress() {
        if (this.usbSerialNo == null || this.usbSerialNo.length() == 0) {
            return "";
        }
        return Long.toString(this.usbSerialNoAsLong() % 100000000L);
    }

    protected boolean UsbSerialMatch(LoadDeviceConfig.LoadDevice ld) {
        String s = ld.getAddress();
        if (s == null || s.trim().length() == 0 || s.equals("-")) {
            ld.setAddress(this.usbSerialNoAsAddress());
            return true;
        }
        return ld.getAddress().equals(this.usbSerialNoAsAddress());
    }

    @Override
    public int getSerialId() {
        long sn = this.usbSerialNoAsLong();
        if (sn == 0L) {
            sn = this.vendor + this.product;
        }
        return (int)(sn % 100L);
    }
}

