/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.shared.SharedInterface;

public class GpibInterface
extends CommInterface {
    private int localAddress = 0;
    private SharedInterface sif = null;

    public GpibInterface(SharedInterface sif, int localAddress) {
        this.sif = sif;
        this.localAddress = localAddress;
    }

    @Override
    public String getAddress() {
        return String.valueOf(this.sif.getId()) + ":" + Integer.toString(this.localAddress);
    }

    @Override
    public String getName() {
        return String.valueOf(this.sif.getName()) + ":" + this.localAddress;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.GPIB;
    }

    @Override
    public void open() {
        this.sif.open(this.localAddress);
    }

    @Override
    public void close() {
        this.sif.close(this.localAddress);
    }

    public void setReadEol(String format) {
        this.sif.setReadEol(this.localAddress, format);
    }

    public void setWriteDelay(int delay) {
        this.sif.setWriteDelay(this.localAddress, delay);
    }

    public void setWriteReadDelay(int delay) {
        this.sif.setWriteReadDelay(this.localAddress, delay);
    }

    public void setReadCount(int count) {
        this.sif.setReadCount(this.localAddress, count);
    }

    @Override
    public synchronized boolean write(String msg) {
        return this.sif.write(this.localAddress, msg);
    }

    @Override
    public boolean isData() {
        return this.sif.isData();
    }

    @Override
    public synchronized String read() {
        return this.sif.read(this.localAddress, this.timeout);
    }

    @Override
    public synchronized byte[] writeReadBin(String msg, int count, int timeout) {
        return this.sif.writeReadBin(msg, count, timeout);
    }

    @Override
    public synchronized String writeRead(String msg, int timeout) {
        return this.sif.writeRead(this.localAddress, msg, timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        return this.sif.read(this.localAddress, timeout);
    }

    @Override
    public boolean isOpen() {
        return this.sif.isOpen();
    }

    public void writeControl(String ctrl) {
        this.sif.writeControl(ctrl);
    }

    @Override
    public int getSerialId() {
        return this.localAddress;
    }
}

