/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import java.nio.charset.Charset;

public abstract class CommInterface
implements Comparable<CommInterface> {
    private final boolean debug = false;
    protected String eol = "\n";
    public boolean debugLog = false;
    protected int timeout = 1000;
    protected Charset charset = Charset.forName("ISO-8859-1");

    public abstract String getName();

    public CommDataInterface getDataInterface() {
        return null;
    }

    public abstract ManageDeviceDefinitions.PortType getPortType();

    public void setCharset(String name) {
        if (name != null && !name.isEmpty()) {
            this.charset = Charset.forName(name);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getDeviceName() {
        return this.getName();
    }

    public void setEOL(String eol) {
        if (eol == null) {
            return;
        }
        this.eol = eol;
    }

    public String getEOL() {
        return this.eol;
    }

    public abstract String getAddress();

    public abstract void open();

    public abstract void close();

    public void setParams(String params) {
    }

    public abstract boolean write(String var1);

    public void flush() {
    }

    public abstract boolean isData();

    public abstract String read();

    public abstract String read(int var1);

    public synchronized String readLines(int line) {
        StringBuilder sb = new StringBuilder();
        while (line > 0) {
            sb.append(this.read());
            sb.append('\n');
            --line;
        }
        return sb.toString();
    }

    public synchronized String writeReadLines(String msg, int line) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (line > 0) {
            String s = this.read();
            if (s != null) {
                sb.append(s);
            }
            sb.append('\n');
            --line;
        }
        return sb.toString();
    }

    public synchronized String writeReadTimeout(String msg, int timeout) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String s = null;
        int t = this.timeout;
        do {
            if ((s = this.read(t)) != null) {
                sb.append(s);
                sb.append('\n');
            }
            t = timeout;
        } while (s != null);
        return sb.toString();
    }

    public synchronized String writeRead(String msg) {
        return this.writeRead(msg, this.timeout);
    }

    public synchronized String writeRead(String msg, int timeout) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        return this.read(timeout);
    }

    public synchronized byte[] readBin(int count, int timeout) {
        return new byte[0];
    }

    public synchronized boolean writeBin(String msg) {
        return false;
    }

    public synchronized byte[] readSCPIBinary(String cmd) {
        this.write(cmd);
        byte[] b = this.readBin(2, 3000);
        if (b == null || b[0] != 35 || b[1] < 48 || b[1] > 57) {
            return null;
        }
        b = this.readBin(b[1] - 48, 3000);
        int n = 0;
        int i = 0;
        while (i < b.length) {
            n = n * 10 + (b[i] - 48);
            ++i;
        }
        b = this.readBin(n, 3000);
        this.flush();
        return b;
    }

    public synchronized byte[] writeReadBin(String msg, int count, int timeout) {
        return new byte[0];
    }

    public abstract boolean isOpen();

    public String anyRead() {
        if (this.isData()) {
            return this.read();
        }
        return null;
    }

    public void logLog(String msg) {
        if (this.debugLog) {
            this.logLogAlways(msg);
        }
    }

    protected void logLogAlways(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDeviceName());
        sb.append(": ");
        sb.append(msg);
        InterfaceThreads.logDebug(sb.toString());
    }

    protected void log(String msg) {
    }

    protected void log(String msg1, String msg2) {
    }

    public abstract int getSerialId();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("  ");
        sb.append(this.isOpen() ? "Open" : "Closed");
        return sb.toString();
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public int compareTo(CommInterface c1) {
        return this.getDeviceName().compareTo(c1.getDeviceName());
    }
}

