/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.color;

import dk.hkj.util.StringUtil;
import dk.hkj.vars.VarExceptions;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;

public class ColorUtil {
    private static Map<String, Color> mapNameToColor = null;
    private static Map<Color, String> mapColorToName = null;

    private ColorUtil() {
    }

    public static void addToColorMap(String name, Color color) {
        mapNameToColor.put(name, color);
        mapColorToName.put(color, name);
    }

    static void fillColorList() {
        mapNameToColor = new HashMap<String, Color>();
        mapColorToName = new HashMap<Color, String>();
        ColorUtil.addToColorMap("activeCaption", SystemColor.activeCaption);
        ColorUtil.addToColorMap("activeCaptionBorder", SystemColor.activeCaptionBorder);
        ColorUtil.addToColorMap("activeCaptionText", SystemColor.activeCaptionText);
        ColorUtil.addToColorMap("control", SystemColor.control);
        ColorUtil.addToColorMap("controlDkShadow", SystemColor.controlDkShadow);
        ColorUtil.addToColorMap("controlHighlight", SystemColor.controlHighlight);
        ColorUtil.addToColorMap("controlLtHighlight", SystemColor.controlLtHighlight);
        ColorUtil.addToColorMap("controlShadow", SystemColor.controlShadow);
        ColorUtil.addToColorMap("controlText", SystemColor.controlText);
        ColorUtil.addToColorMap("desktop", SystemColor.desktop);
        ColorUtil.addToColorMap("inactiveCaption", SystemColor.inactiveCaption);
        ColorUtil.addToColorMap("inactiveCaptionBorder", SystemColor.inactiveCaptionBorder);
        ColorUtil.addToColorMap("inactiveCaptionText", SystemColor.inactiveCaptionText);
        ColorUtil.addToColorMap("info", SystemColor.info);
        ColorUtil.addToColorMap("infoText", SystemColor.infoText);
        ColorUtil.addToColorMap("menu", SystemColor.menu);
        ColorUtil.addToColorMap("menuText", SystemColor.menuText);
        ColorUtil.addToColorMap("scrollbar", SystemColor.scrollbar);
        ColorUtil.addToColorMap("text", SystemColor.text);
        ColorUtil.addToColorMap("textHighlight", SystemColor.textHighlight);
        ColorUtil.addToColorMap("textHighlightText", SystemColor.textHighlightText);
        ColorUtil.addToColorMap("textInactiveText", SystemColor.textInactiveText);
        ColorUtil.addToColorMap("textText", SystemColor.textText);
        ColorUtil.addToColorMap("window", SystemColor.window);
        ColorUtil.addToColorMap("windowText", SystemColor.windowText);
        ColorUtil.addToColorMap("windowBorder", SystemColor.windowBorder);
        ColorUtil.addToColorMap("aqua", Color.cyan);
        ColorUtil.addToColorMap("black", Color.black);
        ColorUtil.addToColorMap("blue", Color.blue);
        ColorUtil.addToColorMap("cyan", Color.cyan);
        ColorUtil.addToColorMap("darkGray", Color.darkGray);
        ColorUtil.addToColorMap("fuchsia", Color.magenta);
        ColorUtil.addToColorMap("gray", Color.gray);
        ColorUtil.addToColorMap("green", new Color(0, 128, 0));
        ColorUtil.addToColorMap("lightGray", Color.lightGray);
        ColorUtil.addToColorMap("lime", Color.green);
        ColorUtil.addToColorMap("magenta", Color.magenta);
        ColorUtil.addToColorMap("maroon", new Color(128, 0, 0));
        ColorUtil.addToColorMap("navy", new Color(0, 0, 128));
        ColorUtil.addToColorMap("olive", new Color(128, 128, 0));
        ColorUtil.addToColorMap("orange", Color.orange);
        ColorUtil.addToColorMap("pink", Color.pink);
        ColorUtil.addToColorMap("purple", new Color(128, 0, 128));
        ColorUtil.addToColorMap("red", Color.red);
        ColorUtil.addToColorMap("silver", Color.lightGray);
        ColorUtil.addToColorMap("teal", new Color(0, 128, 128));
        ColorUtil.addToColorMap("white", Color.white);
        ColorUtil.addToColorMap("yellow", Color.yellow);
        ColorUtil.addToColorMap("indianred", new Color(205, 92, 92));
        ColorUtil.addToColorMap("lightcoral", new Color(240, 128, 128));
        ColorUtil.addToColorMap("salmon", new Color(250, 128, 114));
        ColorUtil.addToColorMap("darksalmon", new Color(233, 150, 122));
        ColorUtil.addToColorMap("lightsalmon", new Color(255, 160, 122));
        ColorUtil.addToColorMap("crimson", new Color(220, 20, 60));
        ColorUtil.addToColorMap("firebrick", new Color(178, 34, 34));
        ColorUtil.addToColorMap("darkred", new Color(139, 0, 0));
        ColorUtil.addToColorMap("pink", new Color(255, 192, 203));
        ColorUtil.addToColorMap("lightpink", new Color(255, 182, 193));
        ColorUtil.addToColorMap("hotpink", new Color(255, 105, 180));
        ColorUtil.addToColorMap("deeppink", new Color(255, 20, 147));
        ColorUtil.addToColorMap("mediumvioletred", new Color(199, 21, 133));
        ColorUtil.addToColorMap("palevioletred", new Color(219, 112, 147));
        ColorUtil.addToColorMap("coral", new Color(255, 127, 80));
        ColorUtil.addToColorMap("tomato", new Color(255, 99, 71));
        ColorUtil.addToColorMap("orangered", new Color(255, 69, 0));
        ColorUtil.addToColorMap("darkorange", new Color(255, 140, 0));
        ColorUtil.addToColorMap("orange", new Color(255, 165, 0));
        ColorUtil.addToColorMap("gold", new Color(255, 215, 0));
        ColorUtil.addToColorMap("lightyellow", new Color(255, 255, 224));
        ColorUtil.addToColorMap("lemonchiffon", new Color(255, 250, 205));
        ColorUtil.addToColorMap("lightgoldenrodyellow", new Color(250, 250, 210));
        ColorUtil.addToColorMap("papayawhip", new Color(255, 239, 213));
        ColorUtil.addToColorMap("moccasin", new Color(255, 228, 181));
        ColorUtil.addToColorMap("peachpuff", new Color(255, 218, 185));
        ColorUtil.addToColorMap("palegoldenrod", new Color(238, 232, 170));
        ColorUtil.addToColorMap("khaki", new Color(240, 230, 140));
        ColorUtil.addToColorMap("darkkhaki", new Color(189, 183, 107));
        ColorUtil.addToColorMap("lavender", new Color(230, 230, 250));
        ColorUtil.addToColorMap("thistle", new Color(216, 191, 216));
        ColorUtil.addToColorMap("plum", new Color(221, 160, 221));
        ColorUtil.addToColorMap("violet", new Color(238, 130, 238));
        ColorUtil.addToColorMap("orchid", new Color(218, 112, 214));
        ColorUtil.addToColorMap("fuchsia", new Color(255, 0, 255));
        ColorUtil.addToColorMap("magenta", new Color(255, 0, 255));
        ColorUtil.addToColorMap("mediumorchid", new Color(186, 85, 211));
        ColorUtil.addToColorMap("mediumpurple", new Color(147, 112, 219));
        ColorUtil.addToColorMap("rebeccapurple", new Color(102, 51, 153));
        ColorUtil.addToColorMap("blueviolet", new Color(138, 43, 226));
        ColorUtil.addToColorMap("darkviolet", new Color(148, 0, 211));
        ColorUtil.addToColorMap("darkorchid", new Color(153, 50, 204));
        ColorUtil.addToColorMap("darkmagenta", new Color(139, 0, 139));
        ColorUtil.addToColorMap("purple", new Color(128, 0, 128));
        ColorUtil.addToColorMap("indigo", new Color(75, 0, 130));
        ColorUtil.addToColorMap("slateblue", new Color(106, 90, 205));
        ColorUtil.addToColorMap("darkslateblue", new Color(72, 61, 139));
        ColorUtil.addToColorMap("mediumslateblue", new Color(123, 104, 238));
        ColorUtil.addToColorMap("greenyellow", new Color(173, 255, 47));
        ColorUtil.addToColorMap("chartreuse", new Color(127, 255, 0));
        ColorUtil.addToColorMap("lawngreen", new Color(124, 252, 0));
        ColorUtil.addToColorMap("lime", new Color(0, 255, 0));
        ColorUtil.addToColorMap("limegreen", new Color(50, 205, 50));
        ColorUtil.addToColorMap("palegreen", new Color(152, 251, 152));
        ColorUtil.addToColorMap("lightgreen", new Color(144, 238, 144));
        ColorUtil.addToColorMap("mediumspringgreen", new Color(0, 250, 154));
        ColorUtil.addToColorMap("springgreen", new Color(0, 255, 127));
        ColorUtil.addToColorMap("mediumseagreen", new Color(60, 179, 113));
        ColorUtil.addToColorMap("seagreen", new Color(46, 139, 87));
        ColorUtil.addToColorMap("forestgreen", new Color(34, 139, 34));
        ColorUtil.addToColorMap("green", new Color(0, 128, 0));
        ColorUtil.addToColorMap("darkgreen", new Color(0, 100, 0));
        ColorUtil.addToColorMap("yellowgreen", new Color(154, 205, 50));
        ColorUtil.addToColorMap("olivedrab", new Color(107, 142, 35));
        ColorUtil.addToColorMap("olive", new Color(128, 128, 0));
        ColorUtil.addToColorMap("darkolivegreen", new Color(85, 107, 47));
        ColorUtil.addToColorMap("mediumaquamarine", new Color(102, 205, 170));
        ColorUtil.addToColorMap("darkseagreen", new Color(143, 188, 139));
        ColorUtil.addToColorMap("lightseagreen", new Color(32, 178, 170));
        ColorUtil.addToColorMap("darkcyan", new Color(0, 139, 139));
        ColorUtil.addToColorMap("teal", new Color(0, 128, 128));
        ColorUtil.addToColorMap("aqua", new Color(0, 255, 255));
        ColorUtil.addToColorMap("cyan", new Color(0, 255, 255));
        ColorUtil.addToColorMap("lightcyan", new Color(224, 255, 255));
        ColorUtil.addToColorMap("paleturquoise", new Color(175, 238, 238));
        ColorUtil.addToColorMap("aquamarine", new Color(127, 255, 212));
        ColorUtil.addToColorMap("turquoise", new Color(64, 224, 208));
        ColorUtil.addToColorMap("mediumturquoise", new Color(72, 209, 207));
        ColorUtil.addToColorMap("darkturquoise", new Color(0, 206, 209));
        ColorUtil.addToColorMap("cadetblue", new Color(95, 158, 160));
        ColorUtil.addToColorMap("steelblue", new Color(70, 130, 180));
        ColorUtil.addToColorMap("lightsteelblue", new Color(176, 196, 222));
        ColorUtil.addToColorMap("powderblue", new Color(176, 224, 230));
        ColorUtil.addToColorMap("lightblue", new Color(173, 216, 230));
        ColorUtil.addToColorMap("skyblue", new Color(135, 206, 235));
        ColorUtil.addToColorMap("lightskyblue", new Color(135, 206, 250));
        ColorUtil.addToColorMap("deepskyblue", new Color(0, 191, 255));
        ColorUtil.addToColorMap("dodgerblue", new Color(30, 144, 255));
        ColorUtil.addToColorMap("cornflowerblue", new Color(100, 149, 237));
        ColorUtil.addToColorMap("mediumslateblue", new Color(123, 104, 238));
        ColorUtil.addToColorMap("royalblue", new Color(65, 105, 225));
        ColorUtil.addToColorMap("blue", new Color(0, 0, 255));
        ColorUtil.addToColorMap("mediumblue", new Color(0, 0, 205));
        ColorUtil.addToColorMap("darkblue", new Color(0, 0, 139));
        ColorUtil.addToColorMap("navy", new Color(0, 0, 128));
        ColorUtil.addToColorMap("midnightblue", new Color(25, 25, 112));
        ColorUtil.addToColorMap("cornsilk", new Color(255, 248, 220));
        ColorUtil.addToColorMap("blanchedalmond", new Color(255, 235, 205));
        ColorUtil.addToColorMap("bisque", new Color(255, 228, 196));
        ColorUtil.addToColorMap("navajowhite", new Color(255, 222, 173));
        ColorUtil.addToColorMap("wheat", new Color(245, 222, 179));
        ColorUtil.addToColorMap("burlywood", new Color(222, 184, 135));
        ColorUtil.addToColorMap("tan", new Color(210, 180, 140));
        ColorUtil.addToColorMap("rosybrown", new Color(188, 143, 143));
        ColorUtil.addToColorMap("sandybrown", new Color(244, 164, 96));
        ColorUtil.addToColorMap("godenrod", new Color(218, 165, 32));
        ColorUtil.addToColorMap("darkgoldenrod", new Color(184, 134, 11));
        ColorUtil.addToColorMap("peru", new Color(205, 133, 63));
        ColorUtil.addToColorMap("chocolate", new Color(210, 105, 30));
        ColorUtil.addToColorMap("saddlebrown", new Color(139, 69, 19));
        ColorUtil.addToColorMap("sienna", new Color(160, 82, 45));
        ColorUtil.addToColorMap("brown", new Color(165, 42, 42));
        ColorUtil.addToColorMap("maroon", new Color(128, 0, 0));
        ColorUtil.addToColorMap("snow", new Color(255, 250, 250));
        ColorUtil.addToColorMap("honeydew", new Color(240, 255, 240));
        ColorUtil.addToColorMap("mintcream", new Color(245, 255, 250));
        ColorUtil.addToColorMap("azure", new Color(240, 255, 255));
        ColorUtil.addToColorMap("aliceblue", new Color(240, 248, 255));
        ColorUtil.addToColorMap("ghostwhite", new Color(248, 248, 255));
        ColorUtil.addToColorMap("whitesmoke", new Color(245, 245, 245));
        ColorUtil.addToColorMap("seashell", new Color(255, 245, 238));
        ColorUtil.addToColorMap("beige", new Color(245, 245, 220));
        ColorUtil.addToColorMap("oldlace", new Color(253, 245, 230));
        ColorUtil.addToColorMap("floralwhite", new Color(255, 250, 240));
        ColorUtil.addToColorMap("ivory", new Color(255, 255, 240));
        ColorUtil.addToColorMap("antiquewhite", new Color(250, 235, 215));
        ColorUtil.addToColorMap("linen", new Color(250, 240, 230));
        ColorUtil.addToColorMap("lavenderblush", new Color(255, 240, 245));
        ColorUtil.addToColorMap("mistyrose", new Color(255, 228, 225));
        ColorUtil.addToColorMap("gainsboro", new Color(220, 220, 220));
        ColorUtil.addToColorMap("lightgray", new Color(211, 211, 211));
        ColorUtil.addToColorMap("silver", new Color(192, 192, 192));
        ColorUtil.addToColorMap("darkgray", new Color(169, 169, 169));
        ColorUtil.addToColorMap("gray", new Color(128, 128, 128));
        ColorUtil.addToColorMap("dimgray", new Color(105, 105, 105));
        ColorUtil.addToColorMap("lightslategray", new Color(119, 136, 153));
        ColorUtil.addToColorMap("slategray", new Color(112, 128, 144));
        ColorUtil.addToColorMap("darkslategray", new Color(47, 79, 79));
    }

    public static Color nameToColor(String name) {
        if (name.length() == 0) {
            throw new VarExceptions.SyntaxException("Color name is empty");
        }
        if (name.charAt(0) == '(') {
            String[] s = name.substring(1, name.length() - 1).split("[,;]");
            int r = Integer.parseInt(s[0]);
            int g = Integer.parseInt(s[1]);
            int b = Integer.parseInt(s[2]);
            if (s.length == 4) {
                int a = Integer.parseInt(s[3]);
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        if (name.charAt(0) == '#') {
            int r = Integer.parseInt(name.substring(1, 3), 16);
            int g = Integer.parseInt(name.substring(3, 5), 16);
            int b = Integer.parseInt(name.substring(5, 7), 16);
            return new Color(r, g, b);
        }
        if (mapNameToColor == null) {
            ColorUtil.fillColorList();
        }
        Color color = mapNameToColor.get(name.toLowerCase());
        if (name.matches("[0-9]+")) {
            return new Color(Integer.valueOf(name));
        }
        if (color == null) {
            throw new UnknownColorException(name);
        }
        return color;
    }

    public static String colorToName(Color color) {
        String name;
        if (mapColorToName == null) {
            ColorUtil.fillColorList();
        }
        if ((name = mapColorToName.get(color)) != null) {
            return name;
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append('(');
        sb.append(Integer.valueOf(color.getRed()).toString());
        sb.append(',');
        sb.append(Integer.valueOf(color.getGreen()).toString());
        sb.append(',');
        sb.append(Integer.valueOf(color.getBlue()).toString());
        sb.append(')');
        return sb.toString();
    }

    public static String colorToHTMLCode(Color color) {
        if (mapColorToName == null) {
            ColorUtil.fillColorList();
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append('#');
        sb.append(StringUtil.hex2((byte)color.getRed()));
        sb.append(StringUtil.hex2((byte)color.getGreen()));
        sb.append(StringUtil.hex2((byte)color.getBlue()));
        return sb.toString();
    }

    public static Color blend(Color c1, Color c2, float factor) {
        float r = (float)c1.getRed() * (1.0f - factor) + (float)c2.getRed() * factor;
        float g = (float)c1.getGreen() * (1.0f - factor) + (float)c2.getGreen() * factor;
        float b = (float)c1.getBlue() * (1.0f - factor) + (float)c2.getBlue() * factor;
        if (r < 0.0f) {
            r = 0.0f;
        } else if (r > 255.0f) {
            r = 255.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        } else if (g > 255.0f) {
            g = 255.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        } else if (b > 255.0f) {
            b = 255.0f;
        }
        return new Color(r / 255.0f, g / 255.0f, b / 255.0f);
    }

    public static Color blend(Color c1, Color c2, double factor) {
        return ColorUtil.blend(c1, c2, (float)factor);
    }

    public static class UnknownColorException
    extends RuntimeException {
        public UnknownColorException(String msg) {
            super(msg);
        }
    }
}

