/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.color;

import dk.hkj.color.ColorUtil;
import java.awt.Color;

public class ColorHSV
implements Comparable {
    private int h;
    private int s;
    private int v;

    public ColorHSV(int h, int s, int v) {
        this.h = h;
        this.s = s;
        this.v = v;
    }

    public ColorHSV(Color color) {
        this.RGBtoHSV(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ColorHSV(int color) {
        Color c = new Color(color);
        this.RGBtoHSV(c.getRed(), c.getGreen(), c.getBlue());
    }

    public ColorHSV(String colorName) {
        Color color = ColorUtil.nameToColor(colorName);
        this.RGBtoHSV(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ColorHSV(double h, double s, double v) {
        this.h = (int)h;
        this.s = (int)s;
        this.v = (int)v;
    }

    public ColorHSV(float h, float s, float v) {
        this.h = (int)h;
        this.s = (int)s;
        this.v = (int)v;
    }

    public ColorHSV(Color color, float saturation) {
        this.RGBtoHSV(color.getRed(), color.getGreen(), color.getBlue());
        this.s = (int)(saturation * 255.0f);
    }

    private void RGBtoHSV(int r, int g, int b) {
        int min = Math.min(r, Math.min(g, b));
        this.v = Math.max(r, Math.max(g, b));
        int delta = this.v - min;
        this.s = this.v == 0 ? 0 : delta * 255 / this.v;
        if (this.s == 0) {
            this.h = 0;
        } else if (r == this.v) {
            this.h = (g - b) * 60 / delta;
        } else if (g == this.v) {
            this.h = 120 + (b - r) * 60 / delta;
        } else if (b == this.v) {
            this.h = 240 + (r - g) * 60 / delta;
        }
        if (this.h < 0) {
            this.h += 360;
        }
    }

    public Color getRGB() {
        int hTemp = this.h % 360;
        if (this.h < 0) {
            this.h += 360;
        }
        if (this.s == 0) {
            return new Color(this.v, this.v, this.v);
        }
        int f = hTemp % 60;
        int vs = this.v * this.s;
        int p = this.v - vs / 255;
        int q = this.v - vs * f / 15300;
        int t = this.v - vs * (60 - f) / 15300;
        switch (hTemp /= 60) {
            case 0: {
                return new Color(this.v, t, p);
            }
            case 1: {
                return new Color(q, this.v, p);
            }
            case 2: {
                return new Color(p, this.v, t);
            }
            case 3: {
                return new Color(p, q, this.v);
            }
            case 4: {
                return new Color(t, p, this.v);
            }
            case 5: {
                return new Color(this.v, p, q);
            }
        }
        return new Color(0, 0, 0);
    }

    public int getH() {
        return this.h;
    }

    public int getS() {
        return this.s;
    }

    public int getV() {
        return this.v;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setS(int s) {
        this.s = s;
    }

    public void setV(int v) {
        this.v = v;
    }

    public ColorHSV blend(ColorHSV with, float pct) {
        float pctOf1 = 1.0f - pct;
        if (this.s == 0 && with.s == 0) {
            return new ColorHSV(0.0f, 0.0f, (float)this.v * pctOf1 + (float)with.v * pct);
        }
        if (this.s == 0) {
            return new ColorHSV((float)with.h, (float)this.s * pctOf1 + (float)with.s * pct, (float)this.v * pctOf1 + (float)with.v * pct);
        }
        if (with.s == 0) {
            return new ColorHSV((float)this.h, (float)this.s * pctOf1 + (float)with.s * pct, (float)this.v * pctOf1 + (float)with.v * pct);
        }
        if (this.h < with.h) {
            return new ColorHSV((float)this.h * pctOf1 + (float)with.h * pct, (float)this.s * pctOf1 + (float)with.s * pct, (float)this.v * pctOf1 + (float)with.v * pct);
        }
        return new ColorHSV((float)this.h * pctOf1 + (float)(with.h + 360) * pct, (float)this.s * pctOf1 + (float)with.s * pct, (float)this.v * pctOf1 + (float)with.v * pct);
    }

    public ColorHSV blend(Color with, float pct) {
        return this.blend(new ColorHSV(with), pct);
    }

    public int near(ColorHSV hsv) {
        return Math.abs(hsv.h - this.h) * 30 + Math.abs(hsv.s - this.s) + Math.abs(hsv.v - this.v);
    }

    public int near(Color c) {
        return this.near(new ColorHSV(c));
    }

    public int compareTo(Object o) {
        if (o instanceof ColorHSV) {
            ColorHSV hsv = (ColorHSV)o;
            if (this.h > hsv.h) {
                return 1;
            }
            if (this.h < hsv.h) {
                return -1;
            }
            if (this.s > hsv.s) {
                return 1;
            }
            if (this.s < hsv.s) {
                return -1;
            }
            if (this.v > hsv.v) {
                return 1;
            }
            if (this.v < hsv.v) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o instanceof ColorHSV) {
            ColorHSV hsv = (ColorHSV)o;
            return this.h == hsv.h && this.s == hsv.s && this.v == hsv.v;
        }
        return false;
    }

    public int hashCode() {
        return this.h * 256 + this.s * 16 + this.v;
    }

    public String toString() {
        return "H:" + this.h + " S:" + this.s + " V:" + this.v;
    }
}

