# Keygen for Siglent Spectrum Analyzers (SVA1000X, SSA3000X, SSA3000X Plus, SSA3000R)
#
# Thanks to BitByBit & TV84 from the EEVblog forum
#
# Beware: 
#   > Output features must be entered in lower case!


import hashlib

# Enter here the Host ID of your spectrum analyzer (available in System Info)
HOSTID = '0000000000000000'

# Uncomment the Model - depending on the spectrum analyzer you have
#Model = 'SVA1000X'
#Model = 'SSA3000X'
#Model = 'SSA3000X_Plus'
#Model = 'SSA3000R'

#Use CAT for Refl (SSA3000X)
otheropt = ('AMK', 'CAT', 'Refl', 'Meas', 'EMI', 'TG', 'DMA', 'AMA', 'WDMA', 'DTF', 'VNA', 'RT40', '3021', '3032', '3050', '3075', '1HZ', '3M', 'ALL')

hashkey = '5zao9lyua01pp7hjzm3orcq90mds63z6zi5kv7vmv3ih981vlwn06txnjdtas3u2wa8msx61i12ueh14t7kqwsfskg032nhyuy1d9vv2wm925rd18kih9xhkyilobbgy'

def gen(x):
    h = hashlib.md5((
        hashkey +
        Model.ljust(32, '\x00') +
        opt.ljust(5, '\x00') +
        HOSTID.upper().ljust(32, '\x00') +
        '\x00'*48).encode('ascii')
    ).digest()
    key = ''
    for b in h:
        if (b <= 0x2F or b > 0x39) and (b <= 0x60 or b > 0x7A):
            m = b % 0x24
            b = m + (0x57 if m > 9 else 0x30)
        if b == 0x30:
            b = 0x32
        if b == 0x31:
            b = 0x33
        if b == 0x6c:
            b = 0x6d
        if b == 0x6f:
            b = 0x70
        key += chr(b)
    return key.lower()

print('* Generated licenses for the device ' + Model + ' (HOSTID: ' + HOSTID + ').') 
print('* If there is a problem with AMK and Refl licenses, use CAT for AMK and Meas for Refl\r\n')
for opt in otheropt:
    print('{:5} {}'.format(opt, gen(HOSTID)))