* [What Is Miracl](README.md)
* Security Advisory
* [Benchmarks](benchmarks.md)
* [Miracl Standard Curves](miracl-standard-curves.md)
* [IEEE 1363](ieee-1363.md)
* [Elliptic Curves](elliptic-curves.md)
* [Licensing](licensing.md)
* Reference Manual
	* [Low Level Routines](reference-manual/low-level-routines.md)
	* [Advanced Arithmetic Routines](reference-manual/advanced-arithmetic-routines.md)
	* [Montgomery Arithmetic Routines](reference-manual/montgomery-arithmetic-routines.md)
	* [ZZn2 Arithmetic Routines](reference-manual/zzn2-arithmetic-routines.md)
	* [Encryption Routines](reference-manual/encryption-routines.md)
	* [Elliptic Curve Routines](reference-manual/elliptic-curve-routines.md)
	* [Floating Slash Routines](reference-manual/floating-slash-routines.md)
	* [Structure Reference](reference-manual/structure-reference.md)


Security Advisory
---

If you found an issue with MIRACL, cryptographically or in its implementation, we would appreciate your help to make our code and services better.

## How MIRACL approaches security issues

- MIRACL will not take any legal or intimidating action for reporting security vulnerabilities. We ask you however to be responsible and avoid destroying, tampering or doing any action that might hamper the service or disclose private information of others.

- We will make an effort to respond as fast as possible, and will usually acknowledge the issue within that day.  However, we will need to reproduce the issue, and this can take more time. Once we do start trying to reproduce the issue, we will contact you to let you we are working on it. If we can't reproduce it, we will contact you to try to get more information. This is where we would really appreciate your help!

- Once we figure out the issue, we'll come up with a plan to fix it. We will communicate with you our plans and keep you involved during the whole process. We know it's important to you that the issue is fixed promptly. It's important for us too. Depending on severity, turnaround is between 6 hours and 2 days.

- Once the issue is fixed, we'll deploy the patch and inform our customers. Before publishing details about the vulnerability however, we try to wait 2-5 days to allow everyone to patch depending on the severity of the issue.

- As soon as we can, we will publicly post details of the issue on our Blog. If you wish to be named we will contact you to ask for your approval. If you want to remain anonymous, we'll also respect that.

- We appreciate you disclose the issue in a responsible manner. At this point we don't offer cash prices or rewards, but we usually follow-on with you and send you a reward or a freebie.

## Contact us

Please send all issues to <support@miracl.com>.
