* [What Is Miracl](README.md)
* [Security Advisory](security-advisory.md)
* [Benchmarks](benchmarks.md)
* [Miracl Standard Curves](miracl-standard-curves.md)
* IEEE 1363
* [Elliptic Curves](elliptic-curves.md)
* [Licensing](licensing.md)
* Reference Manual
	* [Low Level Routines](reference-manual/low-level-routines.md)
	* [Advanced Arithmetic Routines](reference-manual/advanced-arithmetic-routines.md)
	* [Montgomery Arithmetic Routines](reference-manual/montgomery-arithmetic-routines.md)
	* [ZZn2 Arithmetic Routines](reference-manual/zzn2-arithmetic-routines.md)
	* [Encryption Routines](reference-manual/encryption-routines.md)
	* [Elliptic Curve Routines](reference-manual/elliptic-curve-routines.md)
	* [Floating Slash Routines](reference-manual/floating-slash-routines.md)
	* [Structure Reference](reference-manual/structure-reference.md)


IEEE 1363
---

The IEEE P1363 standard for Public key Cryptography [P1363](http://grouper.ieee.org/groups/1363/) is now complete. A fully multi-threaded IEEE 1363 "wrapper" for MIRACL is available which implements all the cryptographic primitives in this popular standard. It also supports point compression for elliptic curves, and precomputation for faster Digital Signature. GF(p) and GF(2<sup>m</sup>) curves are treated separately. The implemented primitives (some from P1363a) are:

| DLSVDP-DH    | DLSVDP-DHC   | DLSVDP-MQV | DLSVDP-MQVC |
|--------------|--------------|------------|-------------|
| DLSP-NR      | DLVP-NR      | DLSP-DSA   | DLVP-DSA    |
| ECSVDP-DH    | ECSVDP-DHC   | ECSVDP-MQV | ECSVDP-MQVC |
| ECSP-NR      | ECVP-NR      | ECSP-DSA   | ECVP-DSA    |
| IFEP-RSA     | IFDP-RSA     | IFSP-RSA1  | IFVP-RSA1   |
| IFSP-RSA2    | IFVP-RSA2    | IFSP-RW    | IFVP-RW     |
| DLPSP-NR2/PV | DLSP-NR2     | DLVP-NR2   | DLSP-PV     |
| DLVP-PV      | ECPSP-NR2/PV | ECSP-NR2   | ECVP-NR2    |
| ECSP-PV      | ECVP-PV      |            |             |

The following message encoding and auxiliary functions are also implemented (some from P1363a):

| MGF1        | EMSA1/2/3/4 (PSS) | EMSR1/2/3 (PSS-R) |
|-------------|-------------------|-------------------|
| EME1 (OAEP) | KDF1              | KDF2              |
| MAC1 (HMAC) | AES_CBC_IV0       |                   |

Full instructions for evaluation and deployment can be found at the head of the [p1363.c](https://github.com/CertiVox/MIRACL/blob/master/source/p1363/p1363.c) file. These include full instructions for the creation of a Win32/.NET compatible IEEE 1363 Dynamic Link Library (DLL), so that IEEE 1363 functionality can be easily integrated into your Win32/.NET application. A test program implements instances of signature and encryption schemes ECDSA, IFSSA, IFSSR, DLSSR, DLSSR-PV and ECIES.
