* [What Is Miracl](README.md)
* [Security Advisory](security-advisory.md)
* [Benchmarks](benchmarks.md)
* [Miracl Standard Curves](miracl-standard-curves.md)
* [IEEE 1363](ieee-1363.md)
* Elliptic Curves
* [Licensing](licensing.md)
* Reference Manual
	* [Low Level Routines](reference-manual/low-level-routines.md)
	* [Advanced Arithmetic Routines](reference-manual/advanced-arithmetic-routines.md)
	* [Montgomery Arithmetic Routines](reference-manual/montgomery-arithmetic-routines.md)
	* [ZZn2 Arithmetic Routines](reference-manual/zzn2-arithmetic-routines.md)
	* [Encryption Routines](reference-manual/encryption-routines.md)
	* [Elliptic Curve Routines](reference-manual/elliptic-curve-routines.md)
	* [Floating Slash Routines](reference-manual/floating-slash-routines.md)
	* [Structure Reference](reference-manual/structure-reference.md)


Elliptic Curves
---

These curves use the standard Weierstrass parameterisation, and are of the form:

**y<sup>2</sup> = x<sup>3</sup> +Ax +B mod p**

...where p is a prime congruent to 3 mod 4, and A is fixed at -3. A quarter of all randomly generated curves can be transformed into this form.The former condition makes it easier to find points on the curve, and the latter make calculations on the curve somewhat faster.

The motivation is provide a set of curves which, within the limitations mentioned above, are otherwise in no way special. It is thought that by using such curves the user is safe against cryptanalytic advances, except in a circumstance where the whole premise behind Elliptic Curve cryptography collapses and a sub-exponential solution is found for the most general discrete logarithm problem in the elliptic curve setting.

Each curve is with respect to a prime p which is n bits in length. In each case the number of points q on the curve is itself a prime. The prime p is found as the first prime congruent to 3 mod 4 which is found by incrementing a number n bits in length, formed from the first n bits of the mathematical constant pi=3.141592.... The parameter B is formed from the first n bits of the mathematical constant e=2.71828...., incremented until q is prime.

**ssc-160**
```
n=160
B=993193335754933797118314178888153828594854512705
p=1147860701762054730346201299935827782113538756127
q=1147860701762054730346200648614608152209809891831
```
**ssc-192**
```
n=192
B=4265732895672588129268258440977714335632089762934383523494
p=4930024174431634640599033341057067222865862716297522433299
q=4930024174431634640599033341125441632693811654341940586403
```
**ssc-224**
```
n=224
B=18321183280385145938884990414875229336370193019939570227257813318147
p=21174292597673270169193562049053717791882423761323585056162680913631
q=21174292597673270169193562049053723134442099121024262551089688143309
```
**ssc-256**
```
n=256
B=78688883013276200091698248537162581920209762369847930022367595957783191893217
p=90942894222941581070058735694432465663348344332098107489693037779484723616779
q=90942894222941581070058735694432465663288414616171509431879910319924502217783
```
**ssc-288**
```
n=288
B=337966179100791213208996178567593129982221810838428315939365373128820605838874928979766
p=390596756491121423614434954606695289304724084762108334731724254341779347664665278286219
q=390596756491121423614434954606695289304724116479393090921502092797686514928150248753237
```
**ssc-320**
```
n=320
B=1451553686391976948456801799936788618707919738968947956999929796583121697128874465400872041660580
p=1677600295053042228788960243555000810201048522356787237681776606087928304667951345024875097229491
q=1677600295053042228788960243555000810201048522357873106251579120122685384485967275546948559607409
```
**ssc-384**
```
n=384
B=2677643936212245379258831955273195965014103242523976013961762903324499451740187144031703534071217029867094433378961
p=30946263300823101954888425259784296108860594177929936231961025381527827855583154673559277957637088071546809309873019
q=30946263300823101954888425259784296108860594177929936231959195086011429040851460901626189237585847628753659044398489
```
**ssc-512**
```
n=512
B=9111550163858012281440901732746538838772262590143654133938674743542107885492015390851248618042056679983385207705625699101049041930943171450852516780927629
p=10530467723362659054861705371139847026313999328372313651398671272025951445569024729948471343061931586610942824229083371331823229156399790385588443550959087
q=10530467723362659054861705371139847026313999328372313651398671272025951445569144524507377363887941433449823713742916287342504795006316114468040283111710577
```
These curves may be used freely without restriction.
